/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.fuel;

import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1865;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MeltingFuelBuilder
extends AbstractRecipeBuilder<MeltingFuelBuilder> {
    private final FluidIngredient input;
    private final int duration;
    private final int temperature;

    public static MeltingFuelBuilder fuel(FluidStack fluid, int duration) {
        return MeltingFuelBuilder.fuel(FluidIngredient.of(fluid), duration, FluidVariantAttributes.getTemperature((FluidVariant)fluid.getType()) - 300);
    }

    @Override
    public void save(Consumer<class_2444> consumer) {
        if (this.input.getFluids().isEmpty()) {
            throw new IllegalStateException("Must have at least one fluid for dynamic input");
        }
        this.save(consumer, class_7923.field_41173.method_10221((Object)this.input.getFluids().get(0).getFluid()));
    }

    @Override
    public void save(Consumer<class_2444> consumer, class_2960 id) {
        class_2960 advancementId = this.buildOptionalAdvancement(id, "melting_fuel");
        consumer.accept(new Result(id, advancementId));
    }

    private MeltingFuelBuilder(FluidIngredient input, int duration, int temperature) {
        this.input = input;
        this.duration = duration;
        this.temperature = temperature;
    }

    public static MeltingFuelBuilder fuel(FluidIngredient input, int duration, int temperature) {
        return new MeltingFuelBuilder(input, duration, temperature);
    }

    private class Result
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Result(@Nullable class_2960 ID, class_2960 advancementID) {
            super(ID, advancementID);
        }

        public void method_10416(JsonObject json) {
            if (!MeltingFuelBuilder.this.group.isEmpty()) {
                json.addProperty("group", MeltingFuelBuilder.this.group);
            }
            json.add("fluid", MeltingFuelBuilder.this.input.serialize());
            json.addProperty("duration", (Number)MeltingFuelBuilder.this.duration);
            json.addProperty("temperature", (Number)MeltingFuelBuilder.this.temperature);
        }

        public class_1865<?> method_17800() {
            return (class_1865)TinkerSmeltery.fuelSerializer.get();
        }
    }
}

